package easik.sketch.edge;

import org.jgrapht.graph.DefaultEdge;

/**
 *	The GuideEdge is a directed edge which is used only as a visual aid to
 *	the graph drawer. It is rendered differently than the traditional edge, 
 *	and allows constraints to show which entities it applies to. Technically
 *	it should point to arrows, not nodes, but that might be a bit tricky.
 *
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-06 Kevin Green
 */

public class GuideEdge extends DefaultEdge {
	
	/**
	 * Stores whether this edge is highlighted
	 */
	private boolean _isHighlighted;
	
	/**
	 * Creates an edge between the two objects
	 * @param isHighlighted True if the edge is highlighted, false otherwise
	 */	
	public GuideEdge(boolean isHighlighted) {
		_isHighlighted = isHighlighted;
	}
	
	/**
	 * Gets whether the guide edge is highlighted or not
	 * @return true if the edge is highlighted, false otherwise
	 */
	public boolean IsHighlighted(){
		return _isHighlighted;
	}
	
	/**
	 * Sets the edge as highlighted or not
	 * @param isHighlighted true if the edge is highlighted, false if not.
	 */
	public void setHighlighted(boolean isHighlighted){
		_isHighlighted = isHighlighted;
	}
}

